#include "SerialPortSettingsDialog.h"

SerialPortSettingsDialog::SerialPortSettingsDialog(QWidget *parent)
    : QDialog(parent)
{
	ui.setupUi(this);

	connect(ui.okButton, 				SIGNAL(clicked()),
			this, 						  SLOT(accept()) );
	connect(ui.cancelButton, 			SIGNAL(clicked()),
			this, 						  SLOT(reject()) );

}

SerialPortSettingsDialog::~SerialPortSettingsDialog()
{

}


void SerialPortSettingsDialog::resetValues()
{
	m_serialBaudrate = QrfeReaderManager::SERIAL_BAUD_115200;
	m_hwFlowControl  = false;

	ui.baudRateComboBox->setCurrentIndex((int)m_serialBaudrate);
	ui.hwFlowControlCheckBox->setChecked(m_hwFlowControl);
}

QrfeReaderManager::SerialBaud SerialPortSettingsDialog::serialBaudrate()
{
	return m_serialBaudrate;
}

bool SerialPortSettingsDialog::hwFlowControl()
{
	return m_hwFlowControl;
}


int	SerialPortSettingsDialog::exec ()
{
	return QDialog::exec();
}

void SerialPortSettingsDialog::done ( int r )
{
	if(r == QDialog::Accepted)
	{
		m_serialBaudrate	= (QrfeReaderManager::SerialBaud) ui.baudRateComboBox->currentIndex();
		m_hwFlowControl		= ui.hwFlowControlCheckBox->isChecked();
	}

	QDialog::done(r);
}
